% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivpsys.R
\name{ivpsys}
\alias{ivpsys}
\alias{eulersys}
\title{Initial value problems for systems of ordinary differential equations}
\usage{
eulersys(f, x0, y0, h, n)
}
\arguments{
\item{f}{function to integrate}

\item{x0}{the initial value of x}

\item{y0}{the vector initial values of y}

\item{h}{selected step size}

\item{n}{the number of steps}
}
\value{
a data frame of \code{x} and \code{y} values
}
\description{
solve initial value problems for systems ordinary differential equations
}
\details{
The \code{euler} method implements the Euler method for solving
differential equations.  The code{midptivp} method solves initial
value problems using the second-order Runge-Kutta method.  The
\code{rungekutta4} method is the fourth-order Runge-Kutta method.
}
\examples{
f <- function(x, y) { y / (2 * x + 1) }
ivp.euler <- euler(f, 0, 1, 1/100, 100)
}
