% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nthroot.R
\name{nthroot}
\alias{nthroot}
\title{The n-th root formula}
\usage{
nthroot(a, n, tol = 1/1000)
}
\arguments{
\item{a}{a positive real number}

\item{n}{n}

\item{tol}{the permitted error tolerance}
}
\value{
the root
}
\description{
Find the n-th root of real numbers
}
\details{
The \code{nthroot} function finds the \code{n}th root of \code{a} via
an iterative process.
}
\examples{
nthroot(100, 2)
nthroot(65536, 4)
nthroot(1000, 3)

}
\seealso{
Other algebra: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{division}},
  \code{\link{fibonacci}}, \code{\link{horner}},
  \code{\link{isPrime}}, \code{\link{linterp}},
  \code{\link{polyinterp}}, \code{\link{pwiselinterp}},
  \code{\link{quadratic}}
}
\concept{algebra}
