% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recalculateImageDimensions.R
\name{recalculateImageDimensions}
\alias{recalculateImageDimensions}
\title{Get rectangular image dimensions}
\usage{
recalculateImageDimensions(
  visualizeVariables,
  lon_bounds,
  lat_bounds,
  image_def,
  ihsf
)
}
\arguments{
\item{visualizeVariables}{A dataframe containing $lon and $lat values which will be bounded by lon/lat_bounds (data.frame).}

\item{lon_bounds}{Array containing two values for longitude min and max (numeric).}

\item{lat_bounds}{Array containing two values for latitude min and max (numeric).}

\item{image_def}{Minimal image default size for width and height (numeric).}

\item{ihsf}{Image height rescaling factor (numeric).}
}
\description{
Given regional bounds image width and height are computed in order to display a region without distortion.
}
\examples{
visualizeVariables <- list(
 plot_dim = 2,
 date.time = c(format(Sys.time(), format = "\%Y-\%m-\%d \%H:\%M:\%S")),
 data = array(1:4, dim = c(2,2)),
 min_lon = 6,
 max_lon = 9,
 min_lat = 49,
 max_lat = 52,
 lon = c(7, 8),
 lat = c(50, 51),
 vn = "SIS",
 varname = "Surface Downwelling Shortwave Radiation",
 copyrightText = "Example Copyright"
)

ihsf <- 0.1
image_def <- 800
lon_bounds <- c(6, 9)
lat_bounds <- c(49, 52)

recalculateImageDimensions(visualizeVariables, lon_bounds, lat_bounds, image_def, ihsf)

}
