% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/segsites.R
\name{create_segsites}
\alias{create_segsites}
\alias{get_positions}
\alias{get_snps}
\alias{get_trio_locus}
\alias{is_segsites}
\alias{segsites}
\alias{set_positions}
\alias{set_trio_locus}
\title{Segregating Sites}
\usage{
create_segsites(snps, positions, trio_locus = numeric(0), check = TRUE)

get_snps(segsites)

get_positions(segsites)

set_positions(segsites, positions)

get_trio_locus(segsites)

set_trio_locus(segsites, trio_locus)

is_segsites(segsites)
}
\arguments{
\item{snps}{The SNP Matrix}

\item{positions}{A numeric vector indicating the relative positions of each
SNP on the locus.}

\item{trio_locus}{If the locus consists of a locus trio, then this
contains the trio locus each SNP belongs to.}

\item{check}{Whether non-segregating sites are remove from the segregating
sites (\code{TRUE}) or not (\code{FALSE}).}

\item{segsites}{The segregating sites object}
}
\description{
This functions allow the creation and modification of segregating sites
objects, which are on of the most basic statistics that is calculated in
coala. Segregating Sites are primarily a matrix, where each row repesents
a haplotype and each column represents a SNPs. A given entry is either 1 if
the haplotype carries the derived allele for the SNP, or 0 if it carries
the ancestral one.
}
\section{Functions}{
\itemize{
\item \code{get_snps}: Returns the SNP matrix from a segregating sites
object.

\item \code{get_positions}: Returns the SNP's positions from a segregating
sites  object.

\item \code{set_positions}: Sets the SNP's positions in a segregating
sites object.

\item \code{get_trio_locus}: Returns the trio locus positions from a
segregating sites  object.

\item \code{set_trio_locus}: Sets the trio locus in a segregating sites
object.

\item \code{is_segsites}: Checks whether an object is a segsites object.
}}

