% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_migration.R
\name{feat_migration}
\alias{feat_migration}
\title{Feature: Migration/Gene Flow}
\usage{
feat_migration(rate, pop_from = NULL, pop_to = NULL, symmetric = FALSE,
  time = "0")
}
\arguments{
\item{rate}{The migration rate. Can be a numeric or a
\code{\link{parameter}}. The rate is specified as
\eqn{4 * N0 * m}, where \eqn{m} is the fraction of
\code{pop_to} that is replaced by migrants
from \code{pop_from} each generation (in forward time).}

\item{pop_from}{The population from which the individuals leave.}

\item{pop_to}{The population to which the individuals move.}

\item{symmetric}{Use the rate for all pairs of populations.}

\item{time}{The time point at which the migration with the migration
rate is set. The rate applies to the time past warts
of the time point, until it is changed again.}
}
\description{
This feature changes the migration rates at a given time point.
Per default, no migration between the population occurs, which corresponds
to a \code{rate} of \code{0}. Set it to a value greater than zero to
enable migration from one population to another.
}
\details{
When looking forward in time, a fraction of \code{pop_to} that is replaced
by migrants from \code{pop_from} each generation (see \code{rate}). When
looking backwards in time, ancestral lines in \code{pop_to} move to
\code{pop_from} with the given rate.
}
\examples{
# Asymmetric migration between two populations:
model <- coal_model(c(5, 5), 10) +
  feat_migration(0.5, 1, 2) +
  feat_migration(1.0, 2, 1) +
  feat_mutation(5) +
  sumstat_sfs()
simulate(model)

# Three populations that exchange migrations with equal
# rates at times more than 0.5 time units in the past:
model <- coal_model(c(3, 4, 5), 2) +
  feat_migration(1.2, symmetric = TRUE, time = 0.5) +
  feat_mutation(5) +
  sumstat_sfs()
simulate(model)
}
\seealso{
Other features: \code{\link{feat_growth}},
  \code{\link{feat_ignore_singletons}},
  \code{\link{feat_mutation}}, \code{\link{feat_outgroup}},
  \code{\link{feat_pop_merge}},
  \code{\link{feat_recombination}},
  \code{\link{feat_selection}},
  \code{\link{feat_size_change}},
  \code{\link{feat_unphased}}
}

