% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_growth.R
\name{feat_growth}
\alias{feat_growth}
\title{Feature: Exponential population size growth/decline}
\usage{
feat_growth(rate, population = "all", time = "0")
}
\arguments{
\item{rate}{The growth rate. Can be a numeric or a \code{\link{parameter}}.
See \code{Details} for an explanation how the rate affects the
population size.}

\item{population}{The population which growths/declines. Can be
"all" for all populations, or the number of one population.}

\item{time}{The time at which the growth rate is changed. Can also be
a \code{\link{parameter}}.}
}
\description{
This feature changes the growth factor of a population at given
point in time. This factor applies to the time interval further
into the past from this point.
}
\details{
The population size changes by a factor \eqn{exp(-\alpha*t)}, where
\eqn{\alpha} is the growth parameter and \eqn{t} is the time since
the growth has started. For positive alpha, the population will decline
backwards in time or grow forwards in time. For a negative value of
\eqn{\alpha} it will decline (forward in time).
}
\examples{
# Simulate a haploid population that has been expanding for
# the last 2*Ne generations
model <- coal_model(10, 1) +
  feat_growth(5, time = 0) +
  feat_growth(0, time = 1) +
  feat_mutation(10) +
  sumstat_sfs()
simulate(model)
}
\seealso{
For instantaneous population size
         changes: \code{\link{feat_size_change}}

Other features: \code{\link{feat_ignore_singletons}},
  \code{\link{feat_migration}},
  \code{\link{feat_mutation}}, \code{\link{feat_outgroup}},
  \code{\link{feat_pop_merge}},
  \code{\link{feat_recombination}},
  \code{\link{feat_selection}},
  \code{\link{feat_size_change}},
  \code{\link{feat_unphased}}
}

