% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_pop_merge.R
\name{feat_pop_merge}
\alias{feat_pop_merge}
\title{Feature: Population Merge}
\usage{
feat_pop_merge(time, pop_source, pop_target)
}
\arguments{
\item{time}{The time at which the merge occurs.}

\item{pop_source}{The population from which all lines are moved.
This is the newly created population in the speciation event.}

\item{pop_target}{The population to which the lines are moved. This is
the population in which the speciation event occurs.}
}
\description{
Backwards in time, this feature merges one population into another.
Forwards in time, this corresponds to a speciation event.
}
\details{
In addition to the merge, the growth rate of and all migration rates from
the source population will be set to 0 at the time of the merge to mimic
a speciation event forwards in time. Technically, \code{pop_source} is
still present in the model, but not used unless migration to the population
is manually enabled.
}
\examples{
# Two population which merge after 0.5 time units:
model <- coal_model(c(25,25), 1) +
  feat_pop_merge(0.5, 2, 1) +
  feat_mutation(5) +
  sumstat_tajimas_d()
simulate(model)

# An standard isolation-with-migration model:
model_iwm <- model +
  feat_migration(.75, symmetric = TRUE)
simulate(model_iwm)
}
\seealso{
Other features: \code{\link{feat_growth}},
  \code{\link{feat_ignore_singletons}},
  \code{\link{feat_migration}},
  \code{\link{feat_mutation}}, \code{\link{feat_outgroup}},
  \code{\link{feat_recombination}},
  \code{\link{feat_selection}},
  \code{\link{feat_size_change}},
  \code{\link{feat_unphased}}
}

