% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_scale.R
\name{scale_model}
\alias{scale_model}
\title{Function that downscales a coalescent model}
\usage{
scale_model(model, scaling_factor)
}
\arguments{
\item{model}{The model to downscale}

\item{scaling_factor}{The factor by which the number of loci are reduced.
A value of 2 changes to numbers to half their value (rounded),
a value of 3 to a third an so on.}
}
\description{
This function reduces the number of loci in all averaged loci by a
certain factor.
Non-averaged loci as created with \code{\link{locus_single}} are not
modified in any way. This function is primarily designed for jaatha,
and might be unsuitable for other purposes.
}
\examples{
model <- coal_model(10, loci_number = 10) + locus_single(100)
model
# Group 1: 10 loci; group 2: 1 locus

model <- scale_model(model, 3)
model
# Group 1: 3 loci; group 2: 1 locus
}

