% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_mcmf.R
\name{sumstat_mcmf}
\alias{sumstat_mcmf}
\title{Summary Statistic: Most Common Mutation's Frequency}
\usage{
sumstat_mcmf(name = "mcmf", population = 1, transformation = identity,
  expand_mcmf = FALSE, type_expand = 1)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating
a model, the value of the statistics are written to an entry
of the returned list with this name. Summary statistic names
must be unique in a model.}

\item{population}{The population for which the statistic is
calculated. Can also be "all" to calculate it from all populations.}

\item{transformation}{An optional function for transforming
the results of the statistic. If specified, the results of the
transformation are returned instead of the original values.}

\item{expand_mcmf}{Whether to use or not the expanded MCMF. See Details}

\item{type_expand}{Specifies the type of expanded MCMF to be used. See Details}
}
\value{
A numeric vector or matrix containing MCMF for each locus.
  \describe{
   \item{mcmf}{The observed frequency of the mutational pattern
     that is observed most often in the data.}
   \item{bal}{The frequency of derived alleles in the most
     frequently observed mutational pattern.}
   \item{perc_poly}{The percentage of positions that are polymorpic.}
  }
}
\description{
This summary statistic calculates the observed frequency
of the mutational pattern that is observed most often in
the data.
}
\details{
The expand_mcmf = FALSE calculates the mcmf per locus
and returns a vector. The expand_mcmf = TRUE and type_expand = 1
returns the same results as the first column of a Matrix. The
expand_mcmf = TRUE and type_expand = 2 adds the frequency of
derived alleles in the most frequently observed mutational pattern
as a second column. The expand_mcmf = TRUE and type_expand = 3 adds
the percentage of positions that are polymorpic. When
expanded_mcmf = TRUE results are returned as a matrix.
}
\examples{
# Calculate MCMF for a panmictic population
model <- coal_model(10, 2) +
  feat_mutation(50) +
  sumstat_mcmf()
simulate(model)
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_dna}},
  \code{\link{sumstat_file}},
  \code{\link{sumstat_four_gamete}},
  \code{\link{sumstat_ihh}}, \code{\link{sumstat_jsfs}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_sfs}},
  \code{\link{sumstat_tajimas_d}},
  \code{\link{sumstat_trees}}
}

