% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_tajimas_d.R
\name{sumstat_tajimas_d}
\alias{sumstat_tajimas_d}
\title{Summary Statistic: Tajima's D}
\usage{
sumstat_tajimas_d(name = "tajimas_d", population = "all",
  transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.
Can also be "all" to calculate it from all populations.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
On simulation, this returns a vector with the value of Tajima's D for
  each locus.
}
\description{
This statistic calculates Tajima's D from the simulation
results when added to a model. Tajima's D primarily measures
an deviation of singletons from the neutral expectation of
an equilibrium model. Negative values indicate an excess of
singletons, while positive values code a depletion of them.
}
\examples{
# A neutral model that should yield values close to zero:
model <- coal_model(5, 2) +
  feat_mutation(20) +
  feat_recombination(10) +
  sumstat_tajimas_d("taji_d")
stats <- simulate(model)
print(stats$taji_d)
}
\references{
Tajima, F. (1989). "Statistical method for testing the neutral mutation
hypothesis by DNA polymorphism.". Genetics 123 (3): 585-95.
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_dna}},
  \code{\link{sumstat_file}},
  \code{\link{sumstat_four_gamete}},
  \code{\link{sumstat_ihh}}, \code{\link{sumstat_jsfs}},
  \code{\link{sumstat_mcmf}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_sfs}}, \code{\link{sumstat_trees}}
}
