% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus.R
\name{locus}
\alias{locus}
\alias{loci}
\alias{locus_single}
\alias{locus_averaged}
\title{Loci}
\usage{
locus_single(length)

locus_averaged(number, length)
}
\arguments{
\item{length}{The length of the locus in base pairs.}

\item{number}{The number of loci to add.}
}
\description{
This functions adds one or more loci to a model. A locus is a continuous
stretch of DNA of a given length. All loci are simulated independently of each
other, and are genetically unlinked. A model can contain a
large number of different loci created with \code{locus_single}. This will,
however, slow down the simulation. For performance reasons, it is
better to add the same number of loci with averaged length using
\code{locus_averaged} if this simplification is justifiable. Both can also be
combined in a single model. In the results,
the summary statistics for the loci are returned in order in which they
are added to the model.
}
\section{Functions}{
\itemize{
\item \code{locus_single()}: Adds a single locus.

\item \code{locus_averaged()}: Adds multiple loci with equal length.

}}
\examples{
# A model with one locus of length 1005 bp:
coal_model(10) + locus_single(1005)
# This is equivalent to:
coal_model(10, 1, 1005)

# A model can contain multiple loci:
coal_model(5) + locus_single(100) + locus_single(200) + locus_single(300)
# Or more efficient with averaged length:
coal_model(5) + locus_averaged(3, 200)
# Or equivalently:
coal_model(5, 3, 200)

# Single and averaged loci can also be combined arbitrarily:
coal_model(15) + locus_averaged(10, 150) + locus_single(250)
coal_model(15, 10, 150) + locus_single(250) + locus_averaged(10, 350)
}
\seealso{
For adding three loci which are linked to each other:
 \code{\link{locus_trio}}
}
