% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooling.R
\name{get_eligible}
\alias{get_eligible}
\title{Extract surveys from institutes within a specified time-window}
\usage{
get_eligible(surveys, pollsters, last_date = Sys.Date(), period = 14,
  period_extended = NA)
}
\arguments{
\item{surveys}{A \code{tibble} containing survey results for multiple
pollsters as returned by \code{\link[coalitions]{get_surveys}}.}

\item{pollsters}{Character vector of pollsters that should be considered
for pooling.}

\item{last_date}{Only surveys in the time-window from \code{last_date} to
\code{last_date} - period will be considered for each pollster. Defaults
to current date.}

\item{period}{See \code{last_date} argument.}

\item{period_extended}{Optional. If specified, all surveys in the time-window
from \code{last_date} - period_extended to \code{last_date} - period will
also be considered for each pollster, but only after down-weighting them by
halving their true sample size.}
}
\description{
Extract surveys from institutes within a specified time-window
}
\keyword{internal}
