% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{cocoPredict}
\alias{cocoPredict}
\title{Prediction routines for nonstationary spatial models}
\usage{
cocoPredict(coco.object, newdataset, newlocs, type = 'mean', ...)
}
\arguments{
\item{coco.object}{(\code{S4}) a fitted \link{coco} object.}

\item{newdataset}{(\code{data.frame}) a data.frame containing covariates present in model.list at prediction locations.}

\item{newlocs}{(\code{matrix}) a matrix with locations related to prediction locations, matching indexing of \code{newdataset}.}

\item{type}{(\code{character}) whether \code{"mean"} or \code{"pred"}, which gives a point prediction for the former,
as well as of point prediction and standard errors for the latter.}

\item{...}{(\code{character}) when coco.object has multiple realizations, specifying \code{"index.pred"} specifying which column of
\code{coco.object@z} should be used to perform predictions.}
}
\value{
(\code{list}) a list with the conditional mean, splitted into the systematic large-scale variability \code{trend},
and due to stochastic \code{mean}, as well as standard errors \code{"sd.pred"} if \code{"pred"} is specified.
}
\description{
Computes the point predictions and standard errors based on conditional Gaussian distributions.
}
\examples{
\dontrun{
 
model.list <- list('mean' = 0,
'std.dev' = formula( ~ 1 + cov_x + cov_y),
'scale' = formula( ~ 1 + cov_x + cov_y),
'aniso' = 0,
'tilt' = 0,
'smooth' = 3/2,
'nugget' = -Inf)

coco_object <- coco(type = 'dense',
data = holes[[1]][1:100, ],
locs = as.matrix(holes[[1]][1:100, 1:2]),
z = holes[[1]][1:100, ]$z,
model.list = model.list)

optim_coco <- cocoOptim(coco_object,
boundaries = getBoundaries(coco_object,
lower.value = -3, 3))

coco_preds <- cocoPredict(optim_coco, newdataset = holes[[2]],
newlocs = as.matrix(holes[[2]][, 1:2]),
type = "pred")

coco_preds

par(mfrow = c(1, 2))

fields::quilt.plot(main = "mean", holes[[2]][, 1:2], 
coco_preds$mean, xlim = c(-1, 1), ylim = c(-1, 1))
fields::quilt.plot(main = "se", holes[[2]][, 1:2], 
coco_preds$sd.pred, xlim = c(-1, 1), ylim = c(-1, 1))

# Re-do it without considering cov_x and cov_y in the std.dev and scale and compare. 

}

}
\author{
Federico Blasi
}
