% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_datasets.R
\name{create_syndata_mv}
\alias{create_syndata_mv}
\title{Create multivariate synthetic data}
\usage{
create_syndata_mv(Z, W, max_var_arr = rep(1, length(W)))
}
\arguments{
\item{Z}{[N,L] matrix, Latent factors, N observations, L factors}

\item{W}{a [1,K] list of [L,D_k] matrices or [L,D,K] array, Projections from latent factors to 
data, D_k variables per dataset}

\item{max_var_arr}{(optional) [1,K] numeric, Relative maximum amplitude of noise}
}
\value{
A list with elements:
\item{data}{Data collection as a list of data.frames}
\item{Z}{Signals used}
\item{W}{Mixing matrix used}
\item{E}{Noise}
\item{var.coef}{Noise multiplication factor used}

Each dataset is a data.frame to gain compatibility with lm() and glm()
}
\description{
Create multivariate synthetic data
}
