% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_longitudinal_functions.R
\name{coda_glmnet_longitudinal_null}
\alias{coda_glmnet_longitudinal_null}
\title{coda_glmnet_longitudinal_null}
\usage{
coda_glmnet_longitudinal_null(
  x,
  y,
  x_time,
  subject_id,
  ini_time,
  end_time,
  niter = 100,
  covar = NULL,
  alpha = 0.9,
  lambda = "lambda.1se",
  nfolds = 10,
  sig = 0.05
)
}
\arguments{
\item{x}{abundance table in long format (several rows per individual)}

\item{y}{outcome (binary)}

\item{x_time}{observation times}

\item{subject_id}{subject id}

\item{ini_time}{initial time to be analyzed}

\item{end_time}{end time to be analyzed}

\item{niter}{number of sample iterations}

\item{covar}{data frame with covariates (default = NULL)}

\item{alpha}{elastic net parameter (default = 0.9)}

\item{lambda}{penalization parameter (default = "lambda.1se")}

\item{nfolds}{number of folds}

\item{sig}{significance value (default = 0.05)}
}
\value{
list with "accuracy" and "confidence interval"
}
\description{
Performs a permutational test for the coda_glmnet_longitudinal() algorithm:
It provides the distribution of results under the null hypothesis by
implementing the coda_glmnet_longitudinal() on different rearrangements of the response variable.
}
\examples{

set.seed(123) # to reproduce the results

data(ecam_filtered, package = "coda4microbiome")   # load the data

x=x_ecam # microbiome abundance
x_time = metadata$day_of_life    # observation times
subject_id = metadata$studyid   # subject id
y= metadata$diet           # diet ("bd"= breast diet, "fd"=formula diet)
ini_time = 0
end_time = 90

 coda_glmnet_longitudinal_null (x,y, x_time, subject_id, ini_time, end_time,
                                      lambda="lambda.min",nfolds=4, niter=3)


}
\author{
M. Calle - T. Susin
}
