% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda_coxnet.R
\name{plot_riskscore}
\alias{plot_riskscore}
\title{plot_riskscore}
\usage{
plot_riskscore(risk.score, x, time, status, showPlots = TRUE)
}
\arguments{
\item{risk.score}{microbial risk score values resulting from the coda_coxnet model}

\item{x}{original survival data}

\item{time}{time to event or follow up time for right censored data. Must be a vector (type:numeric) specifying time to event for each sample for right censored data.}

\item{status}{event occurrence. Vector (numeric or logical) specifying 0 (or FALSE) for no event occurrence, and 1 (or TRUE) for event occurrence.}

\item{showPlots}{(default: TRUE)}
}
\value{
returns an object of class HeatmapList.
}
\description{
Plots samples ordered by microbial risk score values along time to event.
}
\examples{

set.seed(12345)

data(data_survival, package = "coda4microbiome")
time <- Event_time
status <- Event
crohn_cox <- coda_coxnet(x = x,
                         time = Event_time,
                         status = Event,
                         covar = NULL,
                         lambda = "lambda.1se", nvar = NULL,
                         alpha = 0.9, nfolds = 10, showPlots = TRUE, coef_threshold = 0)
plot_riskscore(risk.score = crohn_cox$risk.score,
                    x = x,
                    time = Event_time,
                    status =  Event,
                    showPlots = TRUE)


#-------------------------------------------------------------------------------
}
\author{
M. Calle, M. Pujolassos, T. Susin
}
