% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{md_pattern}
\alias{md_pattern}
\title{Missing data patterns}
\usage{
md_pattern(data, omit_complete = TRUE, min_freq = 0.01)
}
\arguments{
\item{data}{the dataset}

\item{omit_complete}{defaults to TRUE, omitting variables without missing values}

\item{min_freq}{minimum number of rows to have this missingness pattern}
}
\description{
Generate missingness patterns using \code{\link[mice:md.pattern]{mice::md.pattern()}},
with options to reduce the complexity of the output.
}
\examples{
data("bfi", package = 'psych')
md_pattern(bfi)
md_pattern(bfi, omit_complete = FALSE, min_freq = 0.2)
}
