% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_attributes.R
\name{detect_missing}
\alias{detect_missing}
\alias{detect_missings}
\title{Detect missing values}
\usage{
detect_missing(
  data,
  only_labelled = TRUE,
  negative_values_are_missing = TRUE,
  ninety_nine_problems = TRUE,
  learn_from_labels = TRUE,
  missing = c(),
  non_missing = c(),
  vars = names(data),
  use_labelled_spss = FALSE
)

detect_missings(data, only_labelled_missings = TRUE, ...)
}
\arguments{
\item{data}{the data frame with labelled missing values}

\item{only_labelled}{don't set values to missing if there's no label for them}

\item{negative_values_are_missing}{by default we label negative values as missing}

\item{ninety_nine_problems}{SPSS users often store values as 99/999, should we do this for values with 5*MAD of the median}

\item{learn_from_labels}{if there are labels for missing values of the form \verb{[-1] no answer}, set -1 in the data to the corresponding tagged missing}

\item{missing}{also set these values to missing (or enforce for 99/999 within 5*MAD)}

\item{non_missing}{don't set these values to missing}

\item{vars}{only edit these variables}

\item{use_labelled_spss}{the labelled_spss class has a few drawbacks. Since R can't store missing values like -1 and 99, we're replacing them with letters unless this option is enabled. If you prefer to keep your -1 etc, turn this on.}

\item{only_labelled_missings}{passed to \code{\link[=detect_missing]{detect_missing()}}}

\item{...}{passed to \code{\link[=detect_missing]{detect_missing()}}}
}
\description{
SPSS users frequently label their missing values, but don't set them as missing.
This function will rectify that for negative values and for the values 99 and 999 (only if they're 5*MAD away from the median).
Using different settings, you can also easily tag other missing values.
}
\section{Functions}{
\itemize{
\item \code{detect_missings}: Deprecated version
}}

