% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{as.data.frame.classified}
\alias{as.data.frame.classified}
\alias{as.data.table.classified}
\alias{as.matrix.classified}
\title{Convert output from classify() to matrix/data.frame/data.table}
\usage{
\method{as.data.frame}{classified}(x, ...)

\method{as.data.table}{classified}(x, ...)

\method{as.matrix}{classified}(x, ...)
}
\arguments{
\item{x}{output from \code{\link[=classify]{classify()}}}

\item{...}{ignored}
}
\value{
data frame/data table with:
\itemize{
\item first column named as "id" column specified as input
to \code{\link[=classify]{classify()}} and with data from \code{row.names(x)}
\item all columns from \code{classified}
\item no row names
}

or simply the input matrix without additional attributes
}
\description{
Convert output from classify() to matrix/data.frame/data.table
}
\examples{
x <- classify(c("C80", "I20", "unvalid_code"), "elixhauser")

as.matrix(x)[, 1:3]
as.data.frame(x)[, 1:3]
data.table::as.data.table(x)[, 1:3]

# `as_tibble()` works automatically due to internal use of `as.data.frame()`.
tibble::as_tibble(x)
}
\seealso{
Other classcodes: 
\code{\link{all_classcodes}()},
\code{\link{classcodes}},
\code{\link{codebook}()},
\code{\link{print.classcodes}()},
\code{\link{print.classified}()},
\code{\link{set_classcodes}()},
\code{\link{summary.classcodes}()},
\code{\link{visualize.classcodes}()}
}
\concept{classcodes}
