% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turnover.R
\name{turnover_twoyears}
\alias{turnover_twoyears}
\title{A function to calculate species turnover between two years}
\usage{
turnover_twoyears(d1, d2, species.var, metric = c("total", "disappearance",
  "appearance"))
}
\arguments{
\item{d1}{A dataframe containing a species column from one year}

\item{d2}{A dataframe containing a species column from the following year}

\item{species.var}{The name of the species column in d1 and d2}

\item{metric}{The turnover metric to return; the default, total, returns summed appearances and disappearances relative to total species richness across both years
\itemize{
 \item{appearance: }{ returns the number of appearances in the second year relative to total species richness across both years }
 \item{disappearance: }{ returns the number of disappearances in the second year relative to the total species richness across both years }
 }}
}
\value{
output The specified turnover metric
}
\description{
A function to calculate species turnover between two years
}
