% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turnover.R
\name{turnover}
\alias{turnover}
\title{Species Turnover}
\usage{
turnover(
  df,
  time.var,
  species.var,
  abundance.var,
  replicate.var = NA,
  metric = "total"
)
}
\arguments{
\item{df}{A data frame containing time, species and abundance columns and an optional column of replicates}

\item{time.var}{The name of the time column}

\item{species.var}{The name of the species column}

\item{abundance.var}{The name of the abundance column}

\item{replicate.var}{The name of the optional replicate column}

\item{metric}{The turnover metric to return:
\itemize{
 \item{total: }{The default metric, calculates summed appearances and disappearances relative to total species richness across both time periods.}
 \item{appearance: }{Calculates the number of species that appeared in the second time period relative to total species richness across both time periods.}
 \item{disappearance: }{Calculates the number of species that disappeared in the second time period relative to total species richness across both time periods.}
}}
}
\value{
The turnover function returns a data frame with the following attributes:
\itemize{
 \item{turnover: }{A numeric column with the turnover values. The name of this column is the same as the specified metric (default is "total").}
 \item{time.var: }{A column containing the second time point; the name and type of this column is the same as the time.var column in the input dataframe.}
 \item{replicate.var: }{A column that has same name and type as the replicate.var column, if replication is specified.}
}
}
\description{
Computes species turnover between time periods as the proportion of species either gained or lost relative to the total number of species observed across both time periods.
Includes an option to compute turnover as just the proportion of species gained (i.e., "appearances") or lost (i.e., "disappearances").
}
\details{
The input data frame needs to contain columns for time, species and abundance; time.var, species.var and abundance.var are used to indicate which columns contain those variables.
If multiple replicates are included in the data frame, that column should be specified with replicate.var. Each replicate should reflect a single experimental unit - there must be a single abundance value per species within each time point and replicate.
}
\examples{
 data(knz_001d)

 # Calculate relative total turnover within replicates
 total.res <- turnover(df=knz_001d,  
               time.var = "year", 
               species.var = "species",
               abundance.var = "abundance", 
               replicate.var="subplot")
 
 # Calculate relative species appearances within replicates
 appear.res <- turnover(df=knz_001d, 
               time.var = "year", 
               species.var = "species",
               abundance.var = "abundance",  
               replicate.var="subplot", 
               metric="appearance")
 
 # Calculate relative species disappearances within replicates
 disappear.res <- turnover(df=knz_001d, 
               time.var = "year", 
               species.var = "species",
               abundance.var = "abundance", 
               replicate.var="subplot", 
               metric="disappearance")
 
}
\references{
Cleland, Elsa E., Scott L. Collins, Timothy L. Dickson, Emily C. Farrer, Katherine L. Gross, Laureano A. Gherardi, Lauren M. Hallett, et al. (2013) "Sensitivity of grassland plant community composition to spatial vs. temporal variation in precipitation." Ecology 94, no. 8: 1687-96.
}
