% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{rings}
\alias{rings}
\title{wiggle-match C-14 dating of a tree}
\usage{
rings(
  name = "Ulandryk",
  tree.dir = "trees",
  sep = ",",
  normal = FALSE,
  delta.R = 0,
  delta.STD = 0,
  t.a = 3,
  t.b = 4,
  ask = TRUE,
  age.steps = 1,
  cutoff = 1e-06,
  prob = 0.95,
  cc = 1,
  postbomb = FALSE,
  BCAD = FALSE,
  times = 3,
  talk = TRUE,
  draw = TRUE,
  ...
)
}
\arguments{
\item{name}{Name of the tree. The .csv file should be saved under a folder named exactly the same as \code{name}, and the folder should live under the \code{treedir} folder. The default is Ulandryk.}

\item{tree.dir}{The directory where the folders of the individual trees live. Defaults to \code{tree.dir="trees"}.}

\item{sep}{Separator for the fields in the .csv file. Defaults to a comma.}

\item{normal}{Calculations can be done assuming that the measurements are normally distributed. By default this is set to FALSE and a student-t distribution is used (Christen and Perez 2009)}

\item{delta.R}{The ages can be modelled to have an offset. The mean is 0 by default.}

\item{delta.STD}{The error of the offset. Set to 0 by default.}

\item{t.a}{First parameter for the student-t distribution (defaults to 3; higher numbers make the distribution approximate the normal distribution more).}

\item{t.b}{Second parameter for the student-t distribution (defaults to 4; higher numbers make the distribution approximate the normal distribution more).}

\item{ask}{Whether or not to ask if new folders should be written (if required)}

\item{age.steps}{Steps in years for the calculations. Defaults to 1, every year.}

\item{cutoff}{Value below which probabilities are no longer taken into account. Defaults to 0.000001.}

\item{prob}{After the run, a fit of the model with the dates is calculated, as the ratio of model iterations that fit the hpd ranges of the dates. Defaults to the \code{prob=0.95} hpd ranges.}

\item{cc}{Calibration curve to be used, for glueing to a postbomb curve. Could be 1 (IntCal20; default), 2 (Marine20), 3 (SHCal20) or 4 (custom curve). Normally not used, except in the case where there are postbomb dates (requiring the 'gluing' of pre- and postbomb curves).}

\item{postbomb}{Negative C-14 ages should be calibrated using a postbomb curve. This could be 1 (northern-hemisphere region 1), 2 (NH region 2), 3 (NH region 3), 4 (southern hemisphere regions 1-2), or 5 (SH region 3).}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{times}{The range of years to be calculated, as multiples of the uncertainties of the data points. E.g. if the lab error of the oldest date is 20 years, and times is set to 5, the calculation range will be extended by 20*5 years.}

\item{talk}{Whether or not to provide feedback on folders written into.}

\item{draw}{Whether or not to draw plots.}

\item{...}{Options for the plot. See \code{draw.rings}.}
}
\value{
the probabilities for the relevant calendar years.
}
\description{
Produce a Bayesian wiggle-match date of a tree dated with multiple C-14 dates at exactly known spacing (e.g., every 10 tree-ring years).
}
\details{
The calculations are based on Bwigg (Christen and Litton 1995; Christen 2003). 
In OxCal, this is called a D_Sequence (Bronk Ramsey et al. 2001).

Since only one parameter has to be estimated (the age of the earliest, innermost ring),
a MCMC approach is not necessary nor recommended, and results are calculated analytically.

The tree files should be in plain-text and fields separated by commas, and the file's extension should be ".csv".
The files should start with a line contain the following headers: "lab ID", "C-14 age", "error", "ring", "cc", separated by commas. Then each row should have the corresponding values, also separated by commas.
Rings are counted from the inner ring (0 year old) outwards, so, forward in time. The file should start with the youngest rings, then work downward until reaching the oldest, bottommost dated rings. 
cc should either be 1 (IntCal20; northern hemisphere terrestrial, 2 (Marine20, though we've never heard of marine trees), 3 (SHCal20; southern hemisphere) or 4 (custom curve). 

The default tree is called Ulandryk (Kuzman et al. 2004). As an alternative, a tree can be simulated (see \code{sim.tree()}).

By default, the data are calibrated assuming a student-t distribution, which has wider tails than the normal distribution and deals well with scatter and outliers.
}
\examples{
  rings("Ulandryk", tree.dir=tempdir())
}
\references{
Bronk Ramsey C, van der Plicht J, Weninger B, 2001. 'Wiggle matching' radiocarbon dates. Radiocarbon 43, 381–389.

Christen JA, Litton CD, 1995. A Bayesian approach to wiggle-matching. Journal of Archaeological Science 22, 719-725 \doi{10.1016/0305-4403(95)90002-0}

Christen JA, 2003. Bwigg: An Internet facility for Bayesian radiocarbon wiggle-matching. Internet Archaeology 13. \doi{10.11141/ia.13.2}

Christen JA, Perez S, 2009. A new robust statistical model for radiocarbon data. Radiocarbon 51, 1047-1059

Kuzmin Y, Slusarenko I, Hajdas I, Bonani G, Christen JA. 2004. The comparison of 14C wiggle-matching results for the 'floating' tree-ring chronology of the Ulandryk-4 Burial Ground (Altai Mountains, Siberia). Radiocarbon 46, 943–948.
}
\author{
Maarten Blaauw, J. Andres Christen
}
