% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dcoga_approx}
\alias{dcoga_approx}
\alias{pcoga_approx}
\title{Convolution of Gamma distribuitons with Approximation Method}
\usage{
dcoga_approx(x, shape, rate)

pcoga_approx(x, shape, rate)
}
\arguments{
\item{x}{Quantiles.}

\item{shape}{Numerical vector of shape parameters.}

\item{rate}{Numerical vector of rate parameters.}
}
\description{
Density and distribution function of convolution of gamma distributions
are calculated based on approximation method from Barnabani(2017), which
gives us the benefit of faster calculation speed under three or more
variables case.
}
\examples{
dcoga_approx(1:10, c(1, 2, 3), c(2, 3, 4))
pcoga_approx(1:10, c(1, 2, 3), c(2, 3, 4))

}
\references{
Barnabani, M. (2017). An approximation to the convolution of gamma
distributions. Communications in Statistics - Simulation and Computation
46(1), 331-343.
}
\author{
Chaoran Hu
}
