% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{IndCMap}
\alias{IndCMap}
\title{Individual Cognitive Mapping}
\usage{
IndCMap(project, doc.id)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{doc.id}{The id of a document}
}
\value{
a 'IndCMap' object, a list containing various information that could be use for plotting an Individual Cognitive Map. The most important elements are :
\describe{
\item{"vertex"}{A list of information on Cognitive Map's variables (i.e. vertices or concepts)}
\item{"edg"}{A list of information about relationships}
\item{"graph"}{A graphNEL object}
\item{"eAttrs"}{A list of graphical attributes of edges}
\item{"nAttrs"}{A list of graphical attributes of nodes (vertices)}
\item{"gAttrs"}{A list of graphical attributes of the whole graph}
}
}
\description{
Formatting the data for plotting an Individual Cognitive Map
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

IndCMap(my.project, 1)
}
