% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translation.r
\name{which_trans_table}
\alias{which_trans_table}
\title{Determine the translation table to use for a given phylogenetic group.}
\usage{
which_trans_table(x)
}
\arguments{
\item{x}{a taxonomic designation (allowed ranks: family, order, class, phylum).}
}
\value{
an integer indicating the correct translation table.
}
\description{
Recommends which translation table to use if taxonomic data is available.
The recommendations are based on the translation tables reported for different
taxonomic classifications on the barcode of life database
(http://www.boldsystems.org/index.php).
}
\details{
If which_trans_table is unable to identify a translation table to utilize,
more information on translation tables can be found here: https://www.ncbi.nlm.nih.gov/Taxonomy/Utils/wprintgc.cgi
}
\examples{
which_trans_table("Chordata") #phylum
which_trans_table("Actinopterygii") #class
which_trans_table("Akentrogonida")  #order
which_trans_table("Hydrobiidae") #family
}
