% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{get_crypto_quotes}
\alias{get_crypto_quotes}
\title{Get market quotes}
\usage{
get_crypto_quotes(
  currency = "USD",
  symbol = NULL,
  slug = NULL,
  id = NULL,
  latest = TRUE,
  ...
)
}
\arguments{
\item{currency}{currency code - Default is 'USD'}

\item{symbol}{One or more cryptocurrency symbols.
Example: c("BTC","ETH").}

\item{slug}{Alternatively pass a vector of exchange slugs.
Example: c("binance","cryptsy")}

\item{id}{Alternatively pass one or more CoinMarketCap cryptocurrency IDs.
Example: c(1,2)}

\item{latest}{If `TRUE` (default), only the latest data is retrieved,
otherwise historical data is returned. (NOTE: Historic Data require higher API rights)}

\item{...}{Further arguments can be passed to historical data. Further information
can be found in the \href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyQuotesLatest}{API documentation}}
}
\value{
A dataframe with the latest market quote for 1 or more cryptocurrencies
}
\description{
Get the latest/historical market quotes for 1 or more cryptocurrencies
}
\note{
At least one "id" or "slug" or "symbol" is required for this request.
}
\examples{
\dontrun{
get_crypto_quotes()
get_crypto_quotes(symbol="ETH")
get_crypto_quotes(symbol=c("ETH","BTC"))
get_crypto_quotes(slug=c("litecoin","dogecoin"))
get_crypto_quotes("EUR", id=c(3,4))
get_crypto_quotes(latest = FALSE, symbol = c("BTC","ETH"),
                  time_start = Sys.Date()-180, time_end=Sys.Date(), count = 10,
                  interval = "30m")
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyQuotesLatest}{API documentation}
}
\seealso{
Other Cryptocurrencies: 
\code{\link{get_crypto_listings}()},
\code{\link{get_crypto_map}()},
\code{\link{get_crypto_marketpairs}()},
\code{\link{get_crypto_meta}()},
\code{\link{get_crypto_ohlcv}()},
\code{\link{get_marketcap_ticker_all}()},
\code{\link{get_valid_currencies}()}
}
\concept{Cryptocurrencies}
