% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deque.R
\name{DequeL}
\alias{DequeL}
\title{Double Ended Queue (R implementation)}
\usage{
DequeL(items = NULL)
}
\arguments{
\item{items}{a list of items}
}
\description{
The \code{DequeL} function creates a double ended queue.
Pure R implementation for benchmarking.
}
\details{
Following methods are exposed:
\preformatted{
.$push(item)
.$pushleft(item)
.$pop()
.$popleft()
.$peek()
.$peekleft()
.$extend(q)
.$extendleft(q)
.$clear()
.$remove(item)
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{item}: any R object
\item \code{q}: a DequeL object
}
}
\examples{
q <- DequeL()
q$push("foo")
q$push("bar")
q$pushleft("baz")
q$pop()  # bar
q$popleft()  # baz

q <- DequeL(list("foo", "bar"))
q$push("baz")$pushleft("bla")
}
\seealso{
\link{Deque}
}
