% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordered_dict.R
\name{OrderedDictL}
\alias{OrderedDictL}
\title{Ordered Dictionary (R implementation)}
\usage{
OrderedDictL(items = NULL, keys = NULL)
}
\arguments{
\item{items}{a list of items}

\item{keys}{a list of keys, use \code{names(items)} if \code{NULL}}
}
\description{
The \code{OrderedDictL} function creates an ordered dictionary.
Pure R implementation for benchmarking.
}
\details{
Following methods are exposed:
\preformatted{
.$set(key, value)
.$get(key, default)
.$remove(key)
.$pop(key, default)
.$popitem(last = TRUE)
.$has(key)
.$keys()
.$values()
.$update(d)
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{key}: any R object, key of the item
\item \code{value}: any R object, value of the item
\item \code{default}: optional, the default value of an item if the key is not found
\item \code{d}: an OrderedDict or OrderedDictL
}
}
\examples{
d <- OrderedDictL(list(apple = 5, orange = 10))
d$set("banana", 3)
d$get("apple")
d$as_list()  # the order the item is preserved
d$pop("orange")
d$as_list()  # "orange" is removed
d$set("orange", 3)$set("pear", 7)  # chain methods
}
\seealso{
\link{Dict} and \link{OrderedDict}
}
