% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collegeScorecard-package.R
\docType{data}
\name{school}
\alias{school}
\title{College Scorecard: School Data}
\format{
A data frame with 11,300 rows and 25 variables. Original column names
from the source dataset are noted in parenthesis.

\describe{
\item{\code{id}}{\verb{[integer]} A unique identifier for each institution. (\code{UNITID})}
\item{\code{name}}{\verb{[character]} Institution name. (\code{INSTNM})}
\item{\code{city}}{\verb{[character]} City. (\code{CITY})}
\item{\code{state}}{\verb{[character]} State postcode. (\code{STABBR})}
\item{\code{zip}}{\verb{[character]} ZIP code. (\code{ZIP})}
\item{\code{latitude}}{\verb{[numeric]} Latitude. (\code{LATITUDE})}
\item{\code{longitude}}{\verb{[numeric]} Longitude. (\code{LONGITUDE})}
\item{\code{url}}{\verb{[character]} URL for institution's homepage. (\code{INSTURL})}
\item{\code{deg_predominant}}{\verb{[factor]} Predominant undergraduate degree awarded. (\code{PREDDEG})}
\item{\code{deg_highest}}{\verb{[factor]} Highest degree awarded. (\code{HIGHDEG})}
\item{\code{control}}{\verb{[factor]} Control of institution (IPEDS). (\code{CONTROL})}
\item{\code{locale_type}}{\verb{[factor]} Locale of institution. (\code{LOCALE})}
\item{\code{locale_size}}{\verb{[factor]} Locale of institution. (\code{LOCALE})}
\item{\code{adm_req_test}}{\verb{[factor]} Test score requirements for admission. (\code{ADMCON7})}
\item{\code{is_hbcu}}{\verb{[logical]} Flag for Historically Black College and University. (\code{HBCU})}
\item{\code{is_pbi}}{\verb{[logical]} Flag for predominantly black institution. (\code{PBI})}
\item{\code{is_annhi}}{\verb{[logical]} Flag for Alaska Native Native Hawaiian serving institution. (\code{ANNHI})}
\item{\code{is_tribal}}{\verb{[logical]} Flag for tribal college and university. (\code{TRIBAL})}
\item{\code{is_aanapii}}{\verb{[logical]} Flag for Asian American Native American Pacific Islander-serving institution. (\code{AANAPII})}
\item{\code{is_hsi}}{\verb{[logical]} Flag for Hispanic-serving institution. (\code{HSI})}
\item{\code{is_nanti}}{\verb{[logical]} Flag for Native American non-tribal institution. (\code{NANTI})}
\item{\code{is_only_men}}{\verb{[logical]} Flag for men-only college. (\code{MENONLY})}
\item{\code{is_only_women}}{\verb{[logical]} Flag for women-only college. (\code{WOMENONLY})}
\item{\code{is_only_distance}}{\verb{[logical]} Flag for distance-education-only education. (\code{DISTANCEONLY})}
\item{\code{religious_affiliation}}{\verb{[factor]} Religious affiliation of the institution. (\code{RELAFFIL})}
}
}
\usage{
school
}
\description{
Information about institutions in the U.S. College Scorecard dataset. The
uses the most recent report for each institution. The \code{school} dataset can be
used to filter the \code{scorecard} dataset. Join the two datasets using the \code{id}
column.

The data set contain only colleges that participate in Title IV federal
financial aid programs. In the tidy data set, column names have been changed
for readability and consistency.

You can find the original data set at the U.S. Department of Education's
\href{https://collegescorecard.ed.gov/data/}{College Scorecard website}. The
code for the data transformation process is available at
\url{https://github.com/gadenbuie/scorecard-db}.
}
\references{
\url{https://collegescorecard.ed.gov/data/}
}
\keyword{datasets}
