% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_gam_deviance}
\alias{f_gam_deviance}
\title{Explained Deviance from univariate GAM model}
\usage{
f_gam_deviance(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the response variable}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
Explained deviance
}
\description{
Computes the explained deviance of a response against a predictor via Generalized Additive Model (GAM). This option is slower than \code{\link[=f_rsquared]{f_rsquared()}}, but suitable if you will be fitting GAMs with the resulting preference order.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#this example requires "mgcv" installed in the system
if(requireNamespace(package = "mgcv", quietly = TRUE)){

  f_gam_deviance(
    x = "growing_season_length", #predictor
    y = "vi_mean",               #response
    df = vi
  )

}

}
