% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{coloc.process}
\alias{coloc.process}
\title{Post process a coloc.details result using masking}
\usage{
coloc.process(
  obj,
  hits1 = NULL,
  hits2 = NULL,
  LD = NULL,
  r2thr = 0.01,
  p1 = 1e-04,
  p2 = 1e-04,
  p12 = 1e-06,
  LD1 = LD,
  LD2 = LD,
  mode = c("iterative", "allbutone")
)
}
\arguments{
\item{obj}{object returned by coloc.detail()}

\item{hits1}{lead snps for trait 1. If length > 1, will use
masking}

\item{hits2}{lead snps for trait 2. If length > 1, will use
masking}

\item{LD}{named LD matrix (for masking)}

\item{r2thr}{r2 threshold at which to mask}

\item{p1}{prior probability a SNP is associated with trait 1, default 1e-4}

\item{p2}{prior probability a SNP is associated with trait 2, default 1e-4}

\item{p12}{prior probability a SNP is associated with both traits, default 1e-5}

\item{LD1}{named LD matrix (for masking) for trait 1 only}

\item{LD2}{named LD matrix (for masking) for trait 2 only}

\item{mode}{either "iterative" (default) - successively condition
on signals or "allbutone" - find all putative signals and
condition on all but one of them in each analysis}
}
\value{
data.table of coloc results
}
\description{
Internal helper function
}
\author{
Chris Wallace
}
