% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_raw_image_handling.R
\name{plotImage}
\alias{plotImage}
\title{Display an image in a plot window}
\usage{
plotImage(img)
}
\arguments{
\item{img}{Either a path to an image or a \code{\link{loadImage}} object.}
}
\value{
A plot of the provided image in the current plot window.
}
\description{
Plots an image as an image.
}
\details{
Redundant, but a nice sanity check. Used in a few other functions in
\code{colordistance} package. Takes either a path to an image (RGB or PNG) or
an image object as read in by \code{\link{loadImage}}.
}
\examples{
colordistance::plotImage(system.file("extdata",
"Heliconius/Heliconius_A/Heliconius_01.jpeg", package="colordistance"))
colordistance::plotImage(loadImage(system.file("extdata",
"Heliconius/Heliconius_A/Heliconius_01.jpeg", package="colordistance"),
lower=rep(0.8, 3), upper=rep(1, 3)))
}
