% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{unstructured_pop}
\alias{unstructured_pop}
\title{Simulated Time Series of an Unstructured Temporally Autocorrelated Population}
\usage{
unstructured_pop(start, timesteps, survPhi, fecundPhi, survMean, survSd,
  fecundMean, fecundSd)
}
\arguments{
\item{start}{The starting population size.}

\item{timesteps}{The number of timesteps you want to simulate. Individuals
are added and killed off every timestep according to the survival and
fertility rates. In ecological applications, timesteps are usually years,
but theoretically they can be any length of time.}

\item{survPhi}{The temporal autocorrelation of survival. 0 is white noise (uncorrelated),
positive values are red noise (directly correlated) and negative values are
blue noise (inversely correlated).}

\item{fecundPhi}{The temporal autocorrelation of fecundity. As above.}

\item{survMean}{The mean survival from timestep to timestep. Must be a value
between 0 (all individuals die) and 1 (all individuals live).}

\item{survSd}{The standard deviation of the survival from timestep to
timestep. Must be a value between 0 and 1.}

\item{fecundMean}{The mean fertility: mean offspring produced by each individual per timestep.}

\item{fecundSd}{The standard deviation of the fertility.}
}
\value{
A data frame with four variables: timestep, population (total individuals
  alive at the start of the timestep), newborns (new individuals
  born this timestep), and survivors (individuals who survive this timestep).
}
\description{
This function simulates an unstructured population with
temporally autocorrelated vital rates (survival and fertility). In other
words, this function will show you the dynamics over time of a population
whose survival and fertility is stochastic, but also correlated to the
survival and fertility in the previous year, respectively. The assumptions of the
simulation are that the population is asexually reproducing or female-only,
survival and fertility are the same at all ages / stages,
and that individuals continue to be reproductively capable until they die.
}
\details{
Be advised that not all combinations of values will work. If you set survival and
fertility unrealistically high, the population size will tend toward infinity and
the simulation will fail because the numbers are too large to handle. Use your
common sense as a demographer / population biologist.
}
\examples{
series1 <- unstructured_pop(start = 20, timesteps = 10, survPhi = 0.7, fecundPhi = -0.1,
survMean = 0.6, survSd = 0.52, fecundMean = 1.2, fecundSd = 0.7)
head(series1)
}
