% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBias.R
\name{calcBias}
\alias{calcBias}
\alias{calcbias}
\alias{calcMeanBias}
\alias{MeanBias}
\alias{meanBias}
\alias{meanbias}
\alias{bias}
\alias{calcSdBias}
\alias{calcSeBias}
\title{Bias between Predicted and Actual Thermal Sensation Vote}
\usage{
calcBias(ref, pred)

calcbias(ref, pred)

calcMeanBias(ref, pred)

MeanBias(ref, pred)

meanBias(ref, pred)

meanbias(ref, pred)

bias(ref, pred)

calcSdBias(ref, pred)

calcSeBias(ref, pred)
}
\arguments{
\item{ref}{a numeric item or vector containing categorical actual thermal sensation votes coded from -3 'cold' to +3 'hot'}

\item{pred}{a numeric item or vector containing categorical predicted thermal sensation votes coded from -3 'cold' to +3 'hot'}
}
\value{
\code{calcMeanBias} returns a dataframe with the following items:
\item{meanBias}{single value presenting the mean bias between actual and predicted thermal sensation votes}
\item{sdBias}{single value presenting the standard deviation of the mean bias}
\item{seBias}{single value presenting the standard error of the mean bias}
}
\description{
\code{calcMeanBias} calculates the mean bias and its standard deviation and standard error between predicted thermal sensation votes and actual obtained sensation votes
}
\examples{
## Define data
ref <- rnorm(5) # actual thermal sensation votes

pred <- rnorm(5) # predicted thermal sensation votes

calcBias(ref, pred)
}
\references{
Humphreys & Nicol (2002) <doi:10.1016/S0378-7788(02)00018-X>

Schweiker & Wagner (2016) Exploring potentials and limitations of the adaptive thermal heat balance framework Proceedings of 9th Windsor Conference: Making Comfort Relevant Cumberland Lodge, Windsor, UK, 2016.
}
\seealso{
\code{\link{calcTPRTSV}}, \code{\link{calcAvgAcc}}
}
\author{
Marcel Schweiker. Further contribution by Shoaib Sarwar.
}
