% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_functions.R
\name{dir.find}
\alias{dir.find}
\title{Search for directories}
\usage{
dir.find(path = ".", pattern = NULL, up = 5, down = 2)
}
\arguments{
\item{path}{The directory to start searching from.  Default is the current
working directory.}

\item{pattern}{A full or partial name of the directory to find.  If partial,
use the question mark (?) or asterisk (*) characters to indicate
the missing piece. Default is NULL, which will return all directories.}

\item{up}{The number of levels above the base path to search. A value of
zero (0) means that you do not want to search up.  A value of -1 means
you do not want to include the base directory in the search results.
Default is 5 levels up.}

\item{down}{The number of levels below the base path to search. A value of
zero (0) means that you do not want to search down.  A value of -1 means you
do not want to include the base directory in the search results.
Default is 2 levels down.}
}
\value{
A vector of one or more full directory paths that met
the search criteria. The paths in the vector are returned
in the order of matches, according to the search algorithm.  That means
the first directory found will be in position one, and the last
directory found
will be at the end of the vector. A NULL is returned if no
directories met the search criteria.
}
\description{
A function to find directories on the file system. The function
starts from the directory specified in the \code{path} parameter,
and searches outward in a radiating pattern
for the ending directory name in the \code{pattern} parameter.
The \code{up} and \code{down} parameters define the scope of the search.
Results are returned as a vector of full paths in the order encountered.
This function has an advantage over \code{list.dirs} in that it can
search both up and down the file system, and limit the scope of the search.
}
\details{
The \code{dir.find} function attempts to find a directory based on
a full or partial directory name.  The directory name is passed
on the \code{pattern} parameter.
The \code{pattern} accepts both the single character question mark
wild card (?), and the asterisk, multi-character wild card (*).
Searches are case-insensitive.

Starting from the base path specified in the \code{path} parameter,
the function searches
both above and below the base path in an alternating
pattern.  The function will first search the base path, then up one level,
then down one level, and so on.  The boundaries of
the search can be controlled by the \code{up} and \code{down} parameters.

You can control whether or not you want the base directory
included in the results.  To include this directory, ensure both \code{up}
and \code{down} parameters are zero or greater.  If either of these
parameters is set to -1, the base path will be excluded.  For example,
\code{up = 3, down = 1} will search up three levels, and down one level.
\code{up = 3, down = 0} will search up three levels and not search down,
but will include the base directory.  \code{up = 3, down = -1} will search
up three levels, not search down, and not include the base directory in
the results.
}
\examples{
# Search for a directory named "prod"
file.find(pattern = "prod")

# Search for a directory that starts with "dat"
file.find(pattern = "dat*")

# Search for a directory up only
file.find(pattern = "dat*", up = 3, down = 0)

# Search for directories up only, skipping the current working directory
file.find(pattern = "dat*", up = 3, down = -1)

}
\seealso{
Other fileops: 
\code{\link{Sys.path}()},
\code{\link{file.find}()}
}
\concept{fileops}
