% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbol.R
\encoding{UTF-8}
\name{symbol}
\alias{symbol}
\title{Gets UTF-8 symbol characters}
\usage{
symbol(keyword)
}
\arguments{
\item{keyword}{A symbol keyword. This keyword follows HTML conventions. See
the \strong{Keywords} section for a complete list of all supported keywords.}
}
\value{
The requested UTF-8 symbol character or characters.
}
\description{
The \code{symbol} function gets UTF-8 symbol characters. You
can call this function to look up trademarks, Greek letters,
and mathematical operators.  The function uses HTML entity
keywords to indicate which symbol to return.  You may pass more than
one keyword in a single call to get a combined result.  Any characters not
recognized as a keyword will be left alone.  Characters surrounded by
square brackets ([]) will be subscripted.  Characters surrounded by square
brackets and prefixed with an up arrow (^[]) will be superscripted.
}
\section{Keywords}{

The following symbol keywords are available:
\itemize{
  \item \strong{Trademark and Copyright}: copy, reg, trade
  \item \strong{Financial}: cent, euro, pound, rupee, ruble, yen, yuan
  \item \strong{Mathmatical}: asymp, bcong, cong, coprod, empty, fnof,
   ge, int, Int, le, ncong, ne, not, part, plusmn,
   prod, radic, sime, sum
  \item \strong{Logical}: and, cap, cup, comp, cuvee, cuwed, exist,
  forall, fork, isin, nexist, ni, notin,
  notni, nsub, nsup, or, sub, sup, xcap, xcup, xvee, xwedge
  \item \strong{Greek uppercase letters}: Alpha, Beta, Gamma, Delta, Epsilon,
  Zeta, Eta, Theta, Iota, Kappa, Lambda, Mu, Nu, Xi, Omicron, Pi, Rho,
  Sigma, Tau, Upsilon, Phi, Chi, Psi, Omega
  \item \strong{Greek lowercase letters}: alpha, beta, gamma, delta, epsilon,
  zeta, eta, theta, iota, kappa, lambda, mu, nu, xi, omicron, pi, rho,
  sigma, tau, upsilon, phi, chi, psi, omega
  \item \strong{Arrows}: rarr, larr, barr, uarr, darr, harr, rArr, lArr, uArr, dArr, hArr
  \item \strong{Other Symbols}: dagger, ddagger, deg, permil, pertenk, sect
  }
}

\examples{
# Trademark symbol
symbol("My Companytrade")

# Registered Trademark symbol
symbol("My Companyreg")

# Dagger symbol concatenated
paste0(symbol("dagger"), "My footnotes")

# Alpha squared
symbol("alpha^[2]")

# Greek Symbols
symbol("SigmaPsiZeta")

# Useful Math Symbols
symbol("asymp ge le ne plusmn empty fnof radic sum")

# Useful Logical Symbols
symbol("forall isin notin cup cap and or")

# Chemistry
symbol("2H[2] + O[2] barr 2H[2]O")
}
\seealso{
Other utf8: 
\code{\link{subsc}()},
\code{\link{supsc}()}
}
\concept{utf8}
