% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparator.R
\docType{class}
\name{Comparator-class}
\alias{Comparator-class}
\title{Virtual Comparator Class}
\description{
This class represents a function for comparing pairs of
objects. It is the base class from which other types of comparators (e.g.
\code{\linkS4class{NumericComparator}} and \code{\linkS4class{StringComparator}}) are derived.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{a function which takes a pair of arguments \code{x} and \code{y}, and
returns the elementwise scores.}

\item{\code{symmetric}}{a logical of length 1. If TRUE, the comparator is symmetric
in its arguments---i.e. \code{comparator(x, y)} is identical to
\code{comparator(y, x)}.}

\item{\code{distance}}{a logical of length 1. If \code{TRUE}, the comparator produces
distances and satisfies \code{comparator(x, x) = 0}. The comparator may not
satisfy all of the properties of a distance metric.}

\item{\code{similarity}}{a logical of length 1. If \code{TRUE}, the comparator produces
similarity scores.}

\item{\code{tri_inequal}}{a logical of length 1. If \code{TRUE}, the comparator satisfies
the triangle inequality. This is only possible (but not guaranteed) if
\code{distance = TRUE} and \code{symmetric = TRUE}.}
}}

