% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calCo}
\alias{calCo}
\title{Calculate Cartesian coordinates for 1-4 bonded atoms}
\usage{
calCo(prev_atoms, length, bAngle, tAngle)
}
\arguments{
\item{prev_atoms}{a 3x3 matrix of coordinates for atoms A-B-C in dihedral, listed by row}

\item{length}{bond length between atoms C-D in dihedral}

\item{bAngle}{planar bond angle between atoms B-C-D (in degrees)}

\item{tAngle}{dihedral angle formed by atoms A-B-C-D (in degrees)}
}
\value{
Returns the vector of coordinates for the fourth atom in the dihedral
}
\description{
Consider atoms A-B-C-D forming a dihedral. 
Given coordinates for atoms A,B,C of the dihedral,
the dihedral angle, bond angle, and bond length, calculate the Cartesian coordinates
of atom D in the dihedral.
}
\examples{
prevAtoms <- matrix(c(50.051, 37.144, -4.723,
 50.044, 36.248, -3.559,
 51.296, 35.369, -3.476), nrow=3, ncol=3, byrow=TRUE)
calCo(prevAtoms, length=1.33, bAngle=116.8, tAngle=-25.3)

}
