% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_test.R
\name{dc_test}
\alias{dc_test}
\title{Randomization Test of DC and Skew-Symmetry of a Sociomatrix.}
\usage{
dc_test(m, N = 20, ntimes = 10000)
}
\arguments{
\item{m}{A matrix with individuals ordered identically in rows and columns.}

\item{N}{The number of behaviors for each dyad}

\item{ntimes}{Number of simulations}
}
\value{
A list containing p-value of each test, observed values and descriptive
     measures of randomized data.
}
\description{
Randomization Test of DC and Skew-Symmetry of a Sociomatrix.
}
\section{References}{

Leiva D et al, 2008, Testing reciprocity in social interactions: A comparison between the
directional consistency and skew-symmetry statistics, Behav Res Methods.
}

\section{Further details}{

This is a one-sided significance test i.e. that observed values are higher than expected
}
\examples{
m <- matrix(c(NA,2,30,6,19,122,0,NA,18,
0,19,85,0,1,NA,3,8,84,0,0,0,NA,267,50,0,
0,0,5,NA,10,1,0,4,4,1,NA), ncol=6)  #table 2, Vervaecke et al. 2000  - fleeing in bonobos
dc_test(m)

mm = matrix(c(0,9,3,6,12,18,13,0,7,17,45,6,7,2,0,5,8,0,11,26,
12,0,8,6,4,3,0,1,0,2,2,5,0,1,0,0),6,6,TRUE)
dc_test(mm,N=16)
}

