% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{lm}
\alias{lm}
\title{Linear Model Fitting for Complex or Numeric Variables}
\usage{
lm(
  formula,
  data,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = TRUE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
For complex variables there are restrictions on what kinds of formula can be comprehended. See \link{zmodel.matrix} for details.}

\item{data}{an optional data frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data frame) containing
    the variables in the model.  If not found in \code{data}, the
    variables are taken from \code{environment(formula)},
    typically the environment from which \code{lm} is called.}

\item{subset}{an optional vector specifying a subset of observations
    to be used in the fitting process.}

\item{weights}{an optional vector of weights to be used in the fitting
    process.  Should be \code{NULL} or a numeric vector.
    If non-NULL, weighted least squares is used with weights
    \code{weights} (that is, minimizing \code{sum(w*e^2)}); otherwise
    ordinary least squares is used.  See also \sQuote{Details},}

\item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.  The default is set by
    the \code{na.action} setting of \code{\link{options}}, and is
    \code{\link[stats]{na.fail}} if that is unset.  The \sQuote{factory-fresh}
    default is \code{\link[stats]{na.omit}}.  Another possible value is
    \code{NULL}, no action.  Value \code{\link[stats]{na.exclude}} can be useful.}

\item{method}{the method to be used; for fitting, currently only
    \code{method = "qr"} is supported; \code{method = "model.frame"} returns
    the model frame (the same as with \code{model = TRUE}, see below).}

\item{model}{logicals.  If \code{TRUE} the corresponding
    components of the fit (the model frame, the model matrix, the
    response, the QR decomposition) are returned.
  }

\item{x}{logical. If \code{TRUE} return the model matrix of the fit. Default is \code{TRUE}.}

\item{y}{logicals.  If \code{TRUE} the corresponding
    components of the fit (the model frame, the model matrix, the
    response, the QR decomposition) are returned.
  }

\item{qr}{logicals.  If \code{TRUE} the corresponding
    components of the fit (the model frame, the model matrix, the
    response, the QR decomposition) are returned.
  }

\item{singular.ok}{logical. If \code{FALSE} (the default in S but
    not in \R) a singular fit is an error.}

\item{contrasts}{Not implemented for complex variables. See \link{zmodel.matrix} for details. Default is \code{NULL}}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector or matrix of extents
    matching those of the response.  One or more \code{\link[stats]{offset}} terms can be
    included in the formula instead or as well, and if more than one are
    specified their sum is used.  See \code{\link[stats]{model.offset}}.}

\item{...}{additional arguments to be passed to the low level
    regression fitting functions (see below).}
}
\value{
Returns an object of class \code{c("zlm", "lm")}, or for multiple responses \code{c("zlm", "mlm", "lm")}.

The functions \link{summary} and \link{anova} are used to obtain and print a summary and analysis of variance table of the results.
The generic functions \link{coefficients}, \link{effects}, \link{fitted.values} and \link{residuals} extract various useful features of the value returned by lm.
Of course these things can also be accessed by simply using the get element symbol \code{$}.

Objects of class "zlm" are lists with the following components.
\item{\code{coefficients}}{a named vector of coefficients.}
\item{\code{residuals}}{the residuals, that is response minus fitted values.}
\item{\code{fitted.values}}{The fitted values, which are response values obtained by feeding the predictors into the model.}
\item{\code{rank}}{The numeric rank of the fitted linear model.}
\item{\code{weights}}{Numeric. The user supplied weights for the linear fit. If none were given, a vector of \code{1}s of length equal to that of the input data.}
\item{\code{df.residual}}{The residual degrees of freedom.}
\item{\code{call}}{The matched call.}
\item{\code{terms}}{the \link{terms} object used.}
\item{\code{contrasts}}{The contrasts used, as these are not supported this component will probably be \code{NULL}.}
\item{\code{xlevels}}{(only where relevant) a record of the levels of the factors used in fitting.}
\item{\code{offset}}{the offset used (missing if none were used).}\
\item{\code{y}}{if requested, the response used.}
\item{\code{x}}{the model matrix used, unless requested to not return it.}
\item{\code{model}}{if requested, the model frame used.}
\item{\code{na.action}}{(where relevant) information returned by \link{model.frame} on the special handling of NAs.}
\item{\code{assign}}{Used by extractor functions like \link{summary} and \link{effects} to understand variable names. Not included in null fits.}
\item{\code{effects}}{Complex list. See \link{effects} for explanation. Not included in null fits.}
\item{\code{qr}}{unless declined, the output of the \link{qr} object created in the process of fitting. Not included in null fits.}
}
\description{
An adaptation of lm that is compatible with complex variables. If the response is not complex, it calls the standard \code{\link[stats:lm]{stats::lm()}}
Note: It is not capable of dealing with contrasts in the complex case. And it may not understand offsets either.
The formula interpretation is also incapable of handling algebraic expressions in formula.
model.frame needs to be changed to allow complex variables in order to enable these features.
}
\details{
Models for \code{lm} are specified symbolically.  A typical model has
  the form \code{response ~ terms} where \code{response} is the (numeric)
  response vector and \code{terms} is a series of terms which specifies a
  linear predictor for \code{response}.  A terms specification of the form
  \code{first + second} indicates all the terms in \code{first} together
  with all the terms in \code{second} with duplicates removed.  A
  specification of the form \code{first:second} indicates the set of
  terms obtained by taking the interactions of all terms in \code{first}
  with all terms in \code{second}.  The specification \code{first*second}
  indicates the \emph{cross} of \code{first} and \code{second}.  This is
  the same as \code{first + second + first:second}.

  If the formula includes an \code{\link[stats]{offset}}, this is evaluated and
  subtracted from the response.

  If \code{response} is a matrix a linear model is fitted separately by
  least-squares to each column of the matrix.

  See \code{\link[stats]{model.matrix}} for some further details.  The terms in
  the formula will be re-ordered so that main effects come first,
  followed by the interactions, all second-order, all third-order and so
  on: to avoid this pass a \code{terms} object as the formula (see
  \code{\link[stats]{aov}} and \code{demo(glm.vr)} for an example).

  A formula has an implied intercept term.  To remove this use either
  \code{y ~ x - 1} or \code{y ~ 0 + x}.  See \code{\link[stats]{formula}} for
  more details of allowed formulae.

  Non-\code{NULL} \code{weights} can be used to indicate that
  different observations have different variances (with the values in
  \code{weights} being inversely proportional to the variances); or
  equivalently, when the elements of \code{weights} are positive
  integers \eqn{w_i}, that each response \eqn{y_i} is the mean of
  \eqn{w_i} unit-weight observations (including the case that there
  are \eqn{w_i} observations equal to \eqn{y_i} and the data have been
  summarized). However, in the latter case, notice that within-group
  variation is not used.  Therefore, the sigma estimate and residual
  degrees of freedom may be suboptimal; in the case of replication
  weights, even wrong. Hence, standard errors and analysis of variance
  tables should be treated with care.

  \code{lm} calls the lower level functions \code{\link[stats]{lm.fit}}, etc,
  see below, for the actual numerical computations.  For programming
  only, you may consider doing likewise.

  All of \code{weights}, \code{subset} and \code{offset} are evaluated
  in the same way as variables in \code{formula}, that is first in
  \code{data} and then in the environment of \code{formula}.
}
\note{
In \code{complexlm}, the \code{x} parameter defaults to \code{TRUE} so that followup
methods such as \link{predict.lm} have access to the model matrix.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x= xx, y= slop*xx + interc + e)
lm(y ~ x, data = tframe, weights = rep(1,n))
}
\seealso{
\link{lm.fit}, \link{lm.wfit}, \link{zlm.wfit}, \link{zmodel.matrix}, \link{complexdqlrs}
}
