% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{summary.complex}
\alias{summary.complex}
\title{summary method for complex objects}
\usage{
\method{summary}{complex}(object, ..., digits)
}
\arguments{
\item{object}{a complex vector or scalar.}

\item{...}{additional arguments, not used.}

\item{digits}{integer specifying the number of digits to include in the summary values.}
}
\value{
A complex vector containing in order the length, median, mean, variance, and pseudo variance of the object.
The length element will be a positive integer, despite being in the complex mode.
}
\description{
The base summary method for complex objects only reports their length and that they are complex..
This improved method returns the mean, median, variance, and pseudo variance of the given complex object.
}
\examples{
set.seed(4242)
n <- 8
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
summary(foo)
}
