% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apportion_scores_comp.R
\name{apportion_scores_comp}
\alias{apportion_scores_comp}
\title{Apportions outlier scores to composites.}
\usage{
apportion_scores_comp(obj)
}
\arguments{
\item{obj}{The output of \code{comp_tsout_ens}}
}
\value{
A list with the following components:
\item{\code{scores_out}}{The apportioned scores for outliers for timepoints in \code{mv_tsout_ens$outliers} or \code{comp_tsout_ens$outliers}.}
\item{\code{scores_all}}{The apportioned scores for outliers for timepoints in \code{mv_tsout_ens$all} or \code{comp_tsout_ens$all}.}
}
\description{
Apportions outlier scores to composites.
}
\examples{
\donttest{
set.seed(1)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x[25] <- 200
x[320] <- 300
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
X <- X/rowSums(X)
out <- comp_tsout_ens(X, compr=2, fast=FALSE)
apportioned <- apportion_scores_comp(out)
}

}
