% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_list.R
\name{to_list}
\alias{to_list}
\alias{to_vec}
\title{List comprehensions for R}
\usage{
to_list(expr)

to_vec(expr, recursive = TRUE, use.names = FALSE)
}
\arguments{
\item{expr}{expression which starts with \code{for} ,  \code{while} or \code{repeat}.}

\item{recursive}{logical. Should unlisting be applied to list components of result? See \link[base]{unlist} for details.}

\item{use.names}{logical. Should names be preserved? See \link[base]{unlist} for details.}
}
\value{
list for \code{to_list} and vector for \code{to_vec}
}
\description{
\code{to_list} converts usual R loops expressions to list producers.
Expression should be started with \code{for} ,  \code{while} or
\code{repeat}. See examples.
}
\examples{
# rather useless expression - squares of even numbers
to_list(for(i in 1:10) if(i \%\% 2==0) i*i)

# Pythagorean triples
to_list(for (x in 1:30) for (y in x:30) for (z in y:30) if (x^2 + y^2 == z^2) c(x, y, z))

colours = c("red", "green", "yellow", "blue")
things = c("house", "car", "tree")
to_vec(for(x in colours) for(y in things) paste(x, y))

# prime numbers
noprimes = to_vec(for (i in 2:7) for (j in seq(i*2, 99, i)) j)
primes = to_vec(for (x in 2:99) if(!x \%in\% noprimes) x)
primes
}
