% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_commodity_lookup.R
\name{ct_commodity_lookup}
\alias{ct_commodity_lookup}
\title{UN Comtrade commodities database query}
\usage{
ct_commodity_lookup(
  search_terms,
  return_code = FALSE,
  return_char = FALSE,
  verbose = TRUE,
  ignore.case = TRUE,
  ...
)
}
\arguments{
\item{search_terms}{Commodity names or commodity codes, as a char or numeric
vector.}

\item{return_code}{Logical, if set to FALSE, the function will return a
set of commodity descriptions along with commodity codes (as a single
string for each match found), if set to TRUE it will return only the
commodity codes. Default value is FALSE.}

\item{return_char}{Logical, if set to FALSE, the function will return the
matches as a named list, if set to TRUE it will return them as a character
vector. Default value is FALSE.}

\item{verbose}{Logical, if set to TRUE, a warning message will print to
console if any of the elements of input "search_terms" returned no matches
(message will indicate which elements returned no data). Default is TRUE.}

\item{ignore.case}{logical, to be passed along to arg ignore.case within
\code{\link{grepl}}. Default value is TRUE.}

\item{...}{additional args to be passed along to \code{\link{grepl}}.}
}
\value{
A list or character vector of commodity descriptions and/or
 commodity codes that are matches with the elements of "search_terms".
}
\description{
The Comtrade API requires that searches for specific commodities be done
using commodity codes. This is a helper function for querying the
Comtrade commodity database. It takes as input a vector of
commodities or commodity codes. Output is a list or vector of commodity
descriptions or codes associated with the input search_terms. For use with
the UN Comtrade API, full API docs can be found at
\url{https://comtrade.un.org/data/doc/api/}
}
\details{
This function uses regular expressions (regex) to find matches
 within the commodity DB. This means it will treat as a match any commodity
 description that contains the input search term. For more on using regex
 within R, see
 \url{https://stat.ethz.ch/R-manual/R-devel/library/base/html/regex.html}
}
\examples{
# Look up commodity descriptions related to "halibut"
ct_commodity_lookup("halibut",
                    return_code = FALSE,
                    return_char = FALSE,
                    verbose = TRUE)

# Look up commodity codes related to "shrimp".
ct_commodity_lookup("shrimp",
                    return_code = TRUE,
                    return_char = FALSE,
                    verbose = TRUE)
}
\seealso{
\code{\link{grepl}}
}
