% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.conStruct.R
\name{conStruct}
\alias{conStruct}
\title{Run a conStruct analysis.}
\usage{
conStruct(spatial = TRUE, K, freqs, geoDist = NULL, coords,
  prefix = "", n.chains = 1, n.iter = 1000, make.figs = TRUE,
  save.files = TRUE, ...)
}
\arguments{
\item{spatial}{A logical indicating whether to perform a spatial analysis. 
Default is \code{TRUE}.}

\item{K}{An \code{integer} that indicates the number of layers to be 
included in the analysis.}

\item{freqs}{A \code{matrix} of allele frequencies with one column per 
locus and one row per sample.
    Missing data should be indicated with \code{NA}.}

\item{geoDist}{A full \code{matrix} of geographic distance between samples. 
If \code{NULL}, user can only run the nonspatial model.}

\item{coords}{A \code{matrix} giving the longitude and latitude 
(or X and Y coordinates) of the samples.}

\item{prefix}{A character \code{vector} giving the prefix to be attached 
to all output files.}

\item{n.chains}{An integer indicating the number of MCMC chains to be run 
in the analysis. Default is 1.}

\item{n.iter}{An \code{integer} giving the number of iterations each MCMC 
chain is run. Default is 1e3.  If the number of iterations 
is greater than 500, the MCMC is thinned so that the number 
of retained iterations is 500 (before burn-in).}

\item{make.figs}{A \code{logical} value indicating whether to automatically 
make figures once the analysis is complete. Default is 
\code{TRUE}.}

\item{save.files}{A \code{logical} value indicating whether to automatically 
save output and intermediate files once the analysis is
 complete. Default is \code{TRUE}.}

\item{...}{Further options to be passed to rstan::sampling (e.g., adapt_delta).}
}
\value{
This function returns a list with one entry for each chain run 
		(specified with \code{n.chains}). The entry for each chain is named 
		"chain_X" for the Xth chain.  The components of the entries for each 
		are detailed below: 
		\itemize{
			\item \code{posterior} gives parameter estimates over the posterior 
					distribution of the MCMC.
				\itemize{
					\item \code{n.iter} number of MCMC iterations retained for 
							analysis (half of the \code{n.iter} argument 
							specified in the function call).
					\item \code{lpd} vector of log posterior density over the retained 
							MCMC iterations.
					\item \code{nuggets} matrix of estimated nugget parameters with 
							one row per MCMC iteration and one column per sample.
					\item \code{par.cov} array of estimated parametric covariance matrices, 
							for which the first dimension is the number of MCMC iterations.
					\item \code{gamma} vector of estimated gamma parameter.
					\item \code{layer.params} list summarizing estimates of layer-specific 
							parameters. There is one entry for each layer specified, and the 
							entry for the kth layer is named "Layer_k".
						\itemize{
							\item \code{alpha0} vector of estimated alpha0 parameter in the 
									kth layer.
							\item \code{alphaD} vector of estimated alphaD parameter in the 
									kth layer.
							\item \code{alpha2} vector of estimated alpha2 parameter in the 
									kth layer.
							\item \code{mu} vector of estimated mu parameter in the 
									kth layer.
							\item \code{layer.cov} vector of estimated layer-specific 
									covariance parameter in the kth layer.
						}
					\item \code{admix.proportions} array of estimated admixture proportions.
							The first dimension is the number of MCMC iterations, 
							the second is the number of samples, 
								and the third is the number of layers.
				}
		\item \code{MAP} gives point estimates of the parameters listed in the \code{posterior}
							list described above. Values are indexed at the MCMC iteration 
							with the greatest posterior probability.
				\itemize{
					\item \code{index.iter} the iteration of the MCMC with the highest 
							posterior probability, which is used to index all parameters 
							included in the \code{MAP} list
					\item \code{lpd} the greatest value of the posterior probability
					\item \code{nuggets} point estimate of nugget parameters
					\item \code{par.cov} point estimate of parametric covariance
					\item \code{gamma} point estimate of gamma parameter
					\item \code{layer.params} point estimates of all layer-specific parameters 
					\item \code{admix.proportions} point estimates of admixture proportions.
				}
		}
}
\description{
\code{conStruct} runs a conStruct analysis of genetic data.
}
\details{
This function initiates an analysis that uses  
geographic and genetic relationships between samples 
to estimate sample membership (admixture proportions) across 
a user-specified number of layers.

This function acts as a wrapper around a STAN model block determined 
		by the user-specified model (e.g., a spatial model with 3 layers, 
		or a nonspatial model with 5 layers).
		User-specified data are checked for appropriate format and consistent dimensions,
		then formatted into a \code{data.block},
		which is then passed to the STAN model block.
		Along with the \code{conStruct.results} output described above, 
		several objects are saved during the course of a \code{conStruct} call
		(if \code{save.files=TRUE}).
		These are the \code{data.block}, which contains all data passed to the STAN model block,
		\code{model.fit}, which is unprocessed results of the STAN run in \code{stanfit} format,
		and the \code{conStruct.results}, which are saved in the course of the function call
		in addition to being returned.
		If \code{make.figs=TRUE}, running \code{conStruct} will also generate many output figures, 
		which are detailed in the function \code{make.all.the.plots} in this package.
}
\examples{
# load example dataset
data(conStruct.data)

# run example spatial analysis with K=1
	#	
# for this example, make.figs and save.files
#	are set to FALSE, but most users will want them 
#	set to TRUE
my.run <- conStruct(spatial = TRUE,
		 			K = 1,
		 			freqs = conStruct.data$allele.frequencies,
		 			geoDist = conStruct.data$geoDist,
		 			coords = conStruct.data$coords,
		 			prefix = "test",
		 			n.chains = 1,
		 			n.iter = 1e3,
		 			make.figs = FALSE,
		 			save.files = FALSE)

}
