% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fem.R
\name{fem}
\alias{fem}
\title{Create an feature-embedding matrix}
\usage{
fem(x, pre_trained, transform = TRUE, transform_matrix, verbose = TRUE)
}
\arguments{
\item{x}{a quanteda (\code{fcm-class}) feature-co-occurrence-matrix}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform}{(logical) if TRUE (default) apply the 'a la carte' transformation,
if FALSE ouput untransformed averaged embeddings.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{verbose}{(logical) - if TRUE, report the features that had
no overlapping (co-occurring) features with the pretrained embeddings provided.}
}
\value{
a \code{fem-class} object
}
\description{
Given a featureco-occurrence matrix for each feature,
multiply its feature counts (columns) with their
corresponding pre-trained embeddings and average
(usually referred to as averaged or additive embeddings).
If specified and a transformation matrix is provided,
multiply the feature embeddings by the transformation matrix
to obtain the corresponding \verb{a la carte} embeddings.
(see eq 2: https://arxiv.org/pdf/1805.05388.pdf)
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# create feature co-occurrence matrix (set tri = FALSE to work with fem)
toks_fcm <- fcm(toks, context = "window", window = 6,
count = "frequency", tri = FALSE)

# compute feature-embedding matrix
toks_fem <- fem(toks_fcm, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)
}
\keyword{fem}
