% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc.R
\name{ccc}
\alias{ccc}
\title{An Rcpp implementation of Lin's Concordance Correlation Coefficient (CCC)}
\usage{
ccc(x, y)
}
\arguments{
\item{x}{A numeric vector containing \code{x}.}

\item{y}{A numeric vector containing \code{y}.}
}
\value{
A numeric scalar representing the CCC between \code{x} and \code{y}.
}
\description{
This \code{ccc()} function leverages the speed of C++ to implement Lin's Concordance Correlation Coefficient (CCC) via \link{Rcpp}. This
implementation is faster than other varieties of CCC calculation from other packages, i.e.,
\code{\link[DescTools:CCC]{DescTools::CCC()}} and \code{\link[epiR:epi.ccc]{epiR::epi.ccc()}}.
}
\details{
For more details on the calculation of the CCC, see: \url{https://en.wikipedia.org/wiki/Concordance_correlation_coefficient}
}
\examples{
# Create x and y vectors
x <- rnorm(100, sd = 1)
y <- rnorm(length(x), sd = 0.2)

# Calculate CCC between x and y
ccc(x,y)

}
