% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_gtable.R
\name{condformat2grob}
\alias{condformat2grob}
\title{Converts the table to a grid object}
\usage{
condformat2grob(x, draw = TRUE)
}
\arguments{
\item{x}{A condformat_tbl object}

\item{draw}{A logical. If \code{TRUE} (default), the table is
immediately drawn using \code{grid::draw()} and the grob is returned.
If \code{FALSE}, the grob is returned without drawing. Set \code{draw=FALSE}
when using the grob in composite images with \code{\link[gridExtra:arrangeGrob]{gridExtra::grid.arrange()}} or
\code{ggpubr::ggarrange()}.}
}
\value{
the grid object
}
\description{
Converts the table to a grid object
}
\examples{
library(condformat)
data.frame(Student = c("Alice", "Bob", "Charlie"),
           Evaluation = c("Great", "Well done", "Good job!")) \%>\%
 condformat() \%>\%
 condformat2grob()
}
