% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_discrete.R
\name{rule_fill_discrete_}
\alias{rule_fill_discrete_}
\title{Fill column with discrete colors (deprecated)}
\usage{
rule_fill_discrete_(columns, expression = ~., colours = NA, h = c(0,
  360) + 15, c = 100, l = 65, h.start = 0, direction = 1,
  na.value = "#FFFFFF", lockcells = FALSE)
}
\arguments{
\item{columns}{a character vector with the column names or a list with
dplyr select helpers given as formulas or a combination of both}

\item{expression}{a formula to be evaluated with the data that will be used
to determine which cells are to be coloured. See the examples
to use it programmatically}

\item{colours}{a character vector with colours as values and the expression
possible results as names.}

\item{h}{range of hues to use, in [0, 360]}

\item{c}{chroma (intensity of colour), maximum value varies depending on
combination of hue and luminance.}

\item{l}{luminance (lightness), in [0, 100]}

\item{h.start}{hue to start at}

\item{direction}{direction to travel around the colour wheel,
1 = clockwise, -1 = counter-clockwise}

\item{na.value}{a character string with the CSS color to be used in missing values}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\description{
This is a deprecated function
}
\examples{
data(iris)
condformat(iris[c(1,51,101), ]) +
 rule_fill_discrete_(columns=c("Species"))
condformat(iris[c(1,51,101), ]) +
 rule_fill_discrete_("Species", expression=~Sepal.Length > 6)

# Use it programmatically:
color_column_larger_than_threshold <- function(x, column, threshold) {
  condformat(x) +
    rule_fill_discrete_(column,
     expression=~ uq(as.name(column))> uq(threshold))
}
color_column_larger_than_threshold(iris[c(1,51,101),], "Sepal.Length", 6.3)

condformat(iris[c(1,51,101),]) +
 rule_fill_discrete_(columns = list(~dplyr::starts_with("Petal"), "Species"),
                     expression=~Species)

# Custom discrete color values can be specified with a function. The function takes
# the whole column and returns a vector with the colours.
color_pick <- function(column) {
  sapply(column,
    FUN = function(value) {
      if (value < 4.7) {
        return("red")
      } else if (value < 5.0) {
        return("yellow")
      } else {
        return("green")
      }
    })
}
condformat(head(iris)) +
   rule_fill_discrete_("Sepal.Length", ~ color_pick(Sepal.Length), colours = identity)

}
