% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pipeline.R
\name{run_pipeline_dbi}
\alias{run_pipeline_dbi}
\title{A wrapper for running pipelines with a DBI connection invocation query}
\usage{
run_pipeline_dbi(pipeline, query, con, ...)
}
\arguments{
\item{pipeline}{User-provided function with one argument, one row of query results}

\item{query}{A query to execute via the DBI connection}

\item{con}{The DBI connection}

\item{...}{Additional arguments passed to dbSendQuery() and dbFetch()}
}
\description{
A wrapper for running pipelines with a DBI connection invocation query
}
\examples{

\dontrun{
library(whisker)
library(RSQLite)

con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)

#for each cylinder count, count the number of top 5 hps it has
pipeline <- function(params){

  query <- "SELECT
    {{#list}}
    SUM(CASE WHEN hp='{{val}}' THEN 1 ELSE 0 END )as n_hp_{{val}},
  {{/list}}
    cyl
    FROM mtcars
    GROUP BY cyl
  ;"


  dbGetQuery(
    con,
    whisker.render(query,params)
  )
}


#pass the top 5 most common hps as val params
run_pipeline_dbi(
  pipeline,
  '
  SELECT "[" || GROUP_CONCAT("{ ""val"": """ || hp ||  """ }") || "]" AS list
  FROM (
    SELECT
      CAST(hp as INTEGER) as HP,
      count(hp) as cnt
    FROM mtcars
    GROUP BY hp
    ORDER BY cnt DESC
    LIMIT 5
  )
  ',
  con
)


dbDisconnect(con)
}
}
